<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'scriptstore');
define('BASE_URL', 'http://localhost/admin/');

// Upload Directory Configuration
// For cPanel: Use absolute path or relative path from admin folder
// Example: '/home/username/public_html/admin/img' or '../img' or 'img'
define('UPLOAD_DIR', __DIR__ . '/img/push_notifications/'); // Relative to admin folder
define('UPLOAD_URL', BASE_URL . 'img/push_notifications/'); // URL to access uploaded images

// OneSignal Configuration
// Get these from OneSignal Dashboard: Settings > Keys & IDs
define('ONESIGNAL_APP_ID', 'YOUR_ONESIGNAL_APP_ID'); // TODO: Replace with your OneSignal App ID
define('ONESIGNAL_REST_API_KEY', 'YOUR_ONESIGNAL_REST_API_KEY'); // TODO: Replace with your REST API Key

// Establish database connection
function getDbConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    $conn->set_charset("utf8mb4");
    return $conn;
}

// Start session
function startSession() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
}

// Check if admin is logged in
function isAdminLoggedIn() {
    startSession();
    return isset($_SESSION['admin_id']);
}

// Check if user is logged in
function isUserLoggedIn() {
    startSession();
    return isset($_SESSION['user_id']);
}

// Function to send a JSON response
function json_response($data, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

// Sanitize input
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

