<?php
require_once 'config.php';
startSession();

if (!isAdminLoggedIn()) {
    header('Location: login.php');
    exit;
}

$conn = getDbConnection();

// Get statistics
$stats = [];
$stats['products'] = $conn->query("SELECT COUNT(*) as count FROM products")->fetch_assoc()['count'];
$stats['categories'] = $conn->query("SELECT COUNT(*) as count FROM categories")->fetch_assoc()['count'];
$stats['orders'] = $conn->query("SELECT COUNT(*) as count FROM orders")->fetch_assoc()['count'];
$stats['pending_orders'] = $conn->query("SELECT COUNT(*) as count FROM orders WHERE status='pending'")->fetch_assoc()['count'];
$stats['users'] = $conn->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'];
$stats['paid_orders'] = $conn->query("SELECT COUNT(*) as count FROM orders WHERE status='paid'")->fetch_assoc()['count'];

// Get recent orders
$recent_orders = $conn->query("
    SELECT o.*, p.title as product_title, u.name as user_name, u.email 
    FROM orders o 
    LEFT JOIN products p ON o.product_id = p.id 
    LEFT JOIN users u ON o.user_id = u.id 
    ORDER BY o.created_at DESC 
    LIMIT 10
")->fetch_all(MYSQLI_ASSOC);

$conn->close();

$pageTitle = 'Dashboard';
include 'layout_start.php';
?>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

<!-- Stats Cards -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6 mb-6">
                <div class="bg-white rounded-lg shadow-lg p-4 md:p-6 border-l-4 border-blue-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-sm">Total Products</p>
                            <p class="text-3xl font-bold text-gray-800"><?php echo $stats['products']; ?></p>
                        </div>
                        <div class="bg-blue-100 p-4 rounded-full">
                            <i class="fas fa-box text-blue-600 text-2xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-lg p-4 md:p-6 border-l-4 border-green-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-xs md:text-sm">Total Orders</p>
                            <p class="text-2xl md:text-3xl font-bold text-gray-800"><?php echo $stats['orders']; ?></p>
                        </div>
                        <div class="bg-green-100 p-3 md:p-4 rounded-full">
                            <i class="fas fa-shopping-cart text-green-600 text-xl md:text-2xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-lg p-4 md:p-6 border-l-4 border-yellow-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-xs md:text-sm">Pending Orders</p>
                            <p class="text-2xl md:text-3xl font-bold text-gray-800"><?php echo $stats['pending_orders']; ?></p>
                        </div>
                        <div class="bg-yellow-100 p-3 md:p-4 rounded-full">
                            <i class="fas fa-clock text-yellow-600 text-xl md:text-2xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-lg p-4 md:p-6 border-l-4 border-purple-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-xs md:text-sm">Total Users</p>
                            <p class="text-2xl md:text-3xl font-bold text-gray-800"><?php echo $stats['users']; ?></p>
                        </div>
                        <div class="bg-purple-100 p-3 md:p-4 rounded-full">
                            <i class="fas fa-users text-purple-600 text-xl md:text-2xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-lg p-4 md:p-6 border-l-4 border-teal-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-xs md:text-sm">Categories</p>
                            <p class="text-2xl md:text-3xl font-bold text-gray-800"><?php echo $stats['categories']; ?></p>
                        </div>
                        <div class="bg-teal-100 p-3 md:p-4 rounded-full">
                            <i class="fas fa-tags text-teal-600 text-xl md:text-2xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-lg p-4 md:p-6 border-l-4 border-red-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-xs md:text-sm">Paid Orders</p>
                            <p class="text-2xl md:text-3xl font-bold text-gray-800"><?php echo $stats['paid_orders']; ?></p>
                        </div>
                        <div class="bg-red-100 p-3 md:p-4 rounded-full">
                            <i class="fas fa-check-circle text-red-600 text-xl md:text-2xl"></i>
                        </div>
                    </div>
                </div>
            </div>

<!-- Recent Orders -->
<div class="bg-white rounded-lg shadow-lg overflow-hidden mb-6">
    <div class="p-4 md:p-6 border-b border-gray-200">
        <h3 class="text-lg md:text-xl font-bold text-gray-800">Recent Orders</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="w-full min-w-[640px]">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order ID</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Product</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">User</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Date</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php foreach ($recent_orders as $order): ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-3 md:px-6 py-4 whitespace-nowrap text-sm font-medium">#<?php echo $order['id']; ?></td>
                    <td class="px-3 md:px-6 py-4 text-sm max-w-[150px] truncate"><?php echo htmlspecialchars($order['product_title'] ?? 'N/A'); ?></td>
                    <td class="px-3 md:px-6 py-4 text-sm max-w-[120px] truncate"><?php echo htmlspecialchars($order['user_name'] ?? $order['email'] ?? 'Guest'); ?></td>
                    <td class="px-3 md:px-6 py-4 whitespace-nowrap text-sm">৳<?php echo number_format($order['amount'] ?? 0, 2); ?></td>
                    <td class="px-3 md:px-6 py-4 whitespace-nowrap">
                        <?php
                        $statusColors = [
                            'pending' => 'bg-yellow-100 text-yellow-800',
                            'paid' => 'bg-green-100 text-green-800',
                            'rejected' => 'bg-red-100 text-red-800'
                        ];
                        $color = $statusColors[$order['status']] ?? 'bg-gray-100 text-gray-800';
                        ?>
                        <span class="px-2 py-1 rounded-full text-xs font-semibold <?php echo $color; ?>">
                            <?php echo ucfirst($order['status']); ?>
                        </span>
                    </td>
                    <td class="px-3 md:px-6 py-4 whitespace-nowrap text-sm text-gray-500 hidden md:table-cell">
                        <?php echo date('M d, Y', strtotime($order['created_at'])); ?>
                    </td>
                    <td class="px-3 md:px-6 py-4 whitespace-nowrap text-sm">
                        <a href="orders.php?id=<?php echo $order['id']; ?>" class="text-teal-600 hover:text-teal-800">
                            <i class="fas fa-eye"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'layout_end.php'; ?>

