<?php
// Common header for admin panel
$pageTitle = $pageTitle ?? 'Admin Panel';
$showSearch = $showSearch ?? false;
?>
<header class="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-30">
    <div class="flex items-center justify-between px-4 py-3 md:px-6 md:py-4">
        <!-- Mobile menu button -->
        <button id="mobileMenuBtn" class="md:hidden p-2 rounded-md text-gray-600 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-teal-500">
            <i class="fas fa-bars text-xl"></i>
        </button>
        
        <!-- Page Title -->
        <h1 class="text-xl md:text-2xl lg:text-3xl font-bold text-gray-800 truncate">
            <?php echo htmlspecialchars($pageTitle); ?>
        </h1>
        
        <!-- Right side actions -->
        <div class="flex items-center space-x-3">
            <?php if ($showSearch): ?>
                <div class="hidden md:flex items-center">
                    <input type="text" placeholder="Search..." 
                           class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-teal-500 text-sm">
                </div>
            <?php endif; ?>
            
            <!-- User menu -->
            <div class="flex items-center space-x-2">
                <div class="hidden sm:block text-right">
                    <p class="text-sm font-semibold text-gray-800">
                        <?php echo htmlspecialchars($_SESSION['admin_username'] ?? 'Admin'); ?>
                    </p>
                    <p class="text-xs text-gray-500">Administrator</p>
                </div>
                <div class="w-10 h-10 bg-teal-600 rounded-full flex items-center justify-center text-white">
                    <i class="fas fa-user"></i>
                </div>
            </div>
        </div>
    </div>
</header>

