<?php
// Common layout start - include this at the beginning of all admin pages
// Set $pageTitle before including this file
$pageTitle = $pageTitle ?? 'Admin Panel';
$showSearch = $showSearch ?? false;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?> - CodeBazar Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        .material-icons {
            font-family: 'Material Icons';
            font-weight: normal;
            font-style: normal;
            font-size: 24px;
            line-height: 1;
            letter-spacing: normal;
            text-transform: none;
            display: inline-block;
            white-space: nowrap;
            word-wrap: normal;
            direction: ltr;
            -webkit-font-feature-settings: 'liga';
            -webkit-font-smoothing: antialiased;
        }
    </style>
</head>
<body class="bg-gray-100">
    <?php include 'sidebar_mobile.php'; ?>
    
    <!-- Main Content -->
    <div class="md:ml-64 min-h-screen">
        <?php include 'header.php'; ?>
        
        <!-- Page Content -->
        <main class="p-4 md:p-6">

