<?php
// Mobile-friendly sidebar with toggle functionality
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!-- Mobile Overlay -->
<div id="mobileOverlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden md:hidden"></div>

<!-- Sidebar -->
<aside id="sidebar" class="fixed left-0 top-0 h-full bg-gradient-to-b from-teal-700 to-teal-900 text-white w-64 z-50 transform -translate-x-full md:translate-x-0 transition-transform duration-300 ease-in-out flex flex-col">
    <!-- Header -->
    <div class="p-4 md:p-6 border-b border-teal-800">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-xl md:text-2xl font-bold flex items-center">
                    <i class="fas fa-store mr-2"></i>
                    Script Store
                </h1>
                <p class="text-teal-200 text-xs md:text-sm mt-1">Admin Panel</p>
            </div>
            <!-- Close button for mobile -->
            <button id="closeSidebarBtn" class="md:hidden p-2 hover:bg-teal-800 rounded-lg">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
    </div>
    
    <!-- Navigation -->
    <nav class="flex-1 overflow-y-auto py-4">
        <a href="dashboard.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'dashboard.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-home mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Dashboard</span>
        </a>
        <a href="products.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'products.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-box mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Products</span>
        </a>
        <a href="categories.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'categories.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-tags mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Categories</span>
        </a>
        <a href="orders.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'orders.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-shopping-cart mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Orders</span>
        </a>
        <a href="users.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'users.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-users mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Users</span>
        </a>
        <a href="payment_methods.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'payment_methods.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-credit-card mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Payment Methods</span>
        </a>
        <a href="notifications.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'notifications.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-bell mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Notifications</span>
        </a>
        <a href="push_notifications.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'push_notifications.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="fas fa-paper-plane mr-3 w-5"></i> 
            <span class="text-sm md:text-base">Push Notifications</span>
        </a>
        <a href="version.php" class="flex items-center px-4 md:px-6 py-3 <?php echo $currentPage == 'version.php' ? 'bg-teal-800 border-r-4 border-white' : 'text-teal-200 hover:bg-teal-800'; ?> transition">
            <i class="material-icons mr-3" style="font-size: 18px;">system_update</i> 
            <span class="text-sm md:text-base">App Version</span>
        </a>
    </nav>

    <!-- Footer -->
    <div class="p-4 md:p-6 border-t border-teal-800">
        <div class="flex items-center mb-4">
            <div class="w-10 h-10 bg-teal-600 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                <i class="fas fa-user"></i>
            </div>
            <div class="min-w-0 flex-1">
                <p class="font-semibold text-sm md:text-base truncate">
                    <?php echo htmlspecialchars($_SESSION['admin_username'] ?? 'Admin'); ?>
                </p>
                <p class="text-xs text-teal-200">Administrator</p>
            </div>
        </div>
        <a href="logout.php" class="block w-full text-center bg-red-600 hover:bg-red-700 py-2 rounded-lg transition text-sm md:text-base">
            <i class="fas fa-sign-out-alt mr-2"></i>Logout
        </a>
    </div>
</aside>

<script>
// Mobile sidebar toggle
const mobileMenuBtn = document.getElementById('mobileMenuBtn');
const closeSidebarBtn = document.getElementById('closeSidebarBtn');
const sidebar = document.getElementById('sidebar');
const mobileOverlay = document.getElementById('mobileOverlay');

function openSidebar() {
    sidebar.classList.remove('-translate-x-full');
    sidebar.classList.add('translate-x-0');
    mobileOverlay.classList.remove('hidden');
    document.body.style.overflow = 'hidden';
}

function closeSidebar() {
    sidebar.classList.remove('translate-x-0');
    sidebar.classList.add('-translate-x-full');
    mobileOverlay.classList.add('hidden');
    document.body.style.overflow = '';
}

if (mobileMenuBtn) {
    mobileMenuBtn.addEventListener('click', openSidebar);
}

if (closeSidebarBtn) {
    closeSidebarBtn.addEventListener('click', closeSidebar);
}

if (mobileOverlay) {
    mobileOverlay.addEventListener('click', closeSidebar);
}

// Close sidebar when clicking nav links on mobile
document.querySelectorAll('aside nav a').forEach(link => {
    link.addEventListener('click', () => {
        if (window.innerWidth < 768) {
            closeSidebar();
        }
    });
});
</script>

