<?php
require_once 'config.php';
startSession();

if (!isAdminLoggedIn()) {
    header('Location: login.php');
    exit;
}

$conn = getDbConnection();
$users = $conn->query("SELECT * FROM users ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);
$conn->close();

// Base URL for images
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
function getUserImageUrl($profileImage, $baseUrl, $userName) {
    if ($profileImage && !empty($profileImage)) {
        return $baseUrl . '/api/uploads/users/' . htmlspecialchars($profileImage);
    }
    // Return default avatar or initials
    return null;
}

$pageTitle = 'Users Management';
include 'layout_start.php';
?>

<div class="bg-white rounded-lg shadow-lg overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full min-w-[640px]">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">ID</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Image</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Email</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Phone</th>
                    <th class="px-3 md:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Joined</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php foreach ($users as $user): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-3 md:px-6 py-4 whitespace-nowrap text-sm font-medium">#<?php echo $user['id']; ?></td>
                        <td class="px-3 md:px-6 py-4">
                            <?php 
                            $imageUrl = getUserImageUrl($user['profile_image'] ?? null, $baseUrl, $user['name']);
                            if ($imageUrl): 
                            ?>
                                <img src="<?php echo $imageUrl; ?>" 
                                     alt="<?php echo htmlspecialchars($user['name']); ?>" 
                                     class="w-10 h-10 md:w-12 md:h-12 rounded-full object-cover border-2 border-gray-200"
                                     onerror="this.onerror=null; this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'40\' height=\'40\'%3E%3Crect width=\'40\' height=\'40\' fill=\'%23e5e7eb\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dy=\'.3em\' font-size=\'16\' fill=\'%236b7280\'%3E<?php echo strtoupper(substr($user['name'], 0, 1)); ?>%3C/text%3E%3C/svg%3E';">
                            <?php else: ?>
                                <div class="w-10 h-10 md:w-12 md:h-12 rounded-full bg-teal-600 flex items-center justify-center text-white font-semibold text-xs md:text-sm">
                                    <?php echo strtoupper(substr($user['name'] ?? 'U', 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td class="px-3 md:px-6 py-4 text-sm font-medium max-w-[150px] truncate"><?php echo htmlspecialchars($user['name']); ?></td>
                        <td class="px-3 md:px-6 py-4 text-sm hidden md:table-cell max-w-[180px] truncate"><?php echo htmlspecialchars($user['email']); ?></td>
                        <td class="px-3 md:px-6 py-4 text-sm hidden lg:table-cell"><?php echo htmlspecialchars($user['phone'] ?? '-'); ?></td>
                        <td class="px-3 md:px-6 py-4 whitespace-nowrap text-sm text-gray-500 hidden md:table-cell">
                            <?php echo date('M d, Y', strtotime($user['created_at'])); ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'layout_end.php'; ?>

