<?php
/**
 * Error Handler
 * Centralized error handling for API
 */

function sendErrorResponse($message, $code = 400, $details = null) {
    http_response_code($code);
    $response = [
        'success' => false,
        'message' => $message
    ];
    
    if ($details !== null) {
        $response['details'] = $details;
    }
    
    echo json_encode($response);
    exit;
}

function sendSuccessResponse($data = null, $message = 'Success') {
    http_response_code(200);
    $response = [
        'success' => true,
        'message' => $message
    ];
    
    if ($data !== null) {
        $response['data'] = $data;
    }
    
    echo json_encode($response);
    exit;
}

// Set error handler
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    error_log("PHP Error [$errno]: $errstr in $errfile on line $errline");
    
    if (error_reporting() !== 0) {
        sendErrorResponse('An error occurred', 500);
    }
});

// Set exception handler
set_exception_handler(function($exception) {
    error_log("Uncaught exception: " . $exception->getMessage());
    sendErrorResponse('An unexpected error occurred', 500);
});

