<?php
/**
 * Get Dynamic Fields for Social Media Type
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../database.php';

$db = getDB();
$socialTypeId = $_GET['social_type_id'] ?? null;

if (!$socialTypeId) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'social_type_id is required']);
    exit;
}

$stmt = $db->prepare("
    SELECT id, field_name, field_label, field_type, field_options, 
           is_required, placeholder, tooltip, sort_order
    FROM social_media_fields 
    WHERE social_type_id = ? 
    ORDER BY sort_order ASC, id ASC
");
$stmt->execute([$socialTypeId]);
$fields = $stmt->fetchAll();

// Parse JSON options for dropdown fields
foreach ($fields as &$field) {
    if ($field['field_type'] === 'dropdown' && !empty($field['field_options'])) {
        $field['field_options'] = json_decode($field['field_options'], true);
    } else {
        $field['field_options'] = null;
    }
}

echo json_encode([
    'success' => true,
    'data' => $fields
]);

