<?php
/**
 * Health Check API
 * Check API and database status
 */

header('Content-Type: application/json');

$health = [
    'status' => 'ok',
    'timestamp' => date('c'),
    'services' => []
];

// Check database
try {
    require_once __DIR__ . '/../database.php';
    $db = getDB();
    $db->query("SELECT 1");
    $health['services']['database'] = 'ok';
} catch (Exception $e) {
    $health['status'] = 'error';
    $health['services']['database'] = 'error: ' . $e->getMessage();
}

// Check file permissions
$uploadDir = __DIR__ . '/../storage';
if (is_writable($uploadDir)) {
    $health['services']['storage'] = 'ok';
} else {
    $health['status'] = 'warning';
    $health['services']['storage'] = 'not writable';
}

// PHP version
$health['php_version'] = PHP_VERSION;

// Server info
$health['server'] = [
    'software' => $_SERVER['SERVER_SOFTWARE'] ?? 'unknown',
    'php_sapi' => php_sapi_name(),
];

echo json_encode($health, JSON_PRETTY_PRINT);

