<?php
/**
 * API Index
 * Lists all available endpoints
 */

header('Content-Type: application/json');

$endpoints = [
    'authentication' => [
        'POST /auth.php?action=register' => 'Register new user',
        'POST /auth.php?action=login' => 'Login',
        'POST /auth.php?action=google' => 'Google OAuth login',
        'GET /auth.php?action=verify' => 'Verify JWT token',
    ],
    'users' => [
        'GET /users.php' => 'Get current user profile',
        'PUT /users.php' => 'Update profile',
        'POST /users.php?action=switch_role' => 'Switch between buyer/seller',
    ],
    'accounts' => [
        'GET /accounts.php' => 'List accounts (with filters)',
        'GET /accounts.php?id={id}' => 'Get account details',
        'POST /accounts.php' => 'Create account (Seller)',
        'PUT /accounts.php?id={id}' => 'Update account',
        'DELETE /accounts.php?id={id}' => 'Delete account',
    ],
    'orders' => [
        'GET /orders.php?type={type}' => 'List orders (all/buyer/seller)',
        'GET /orders.php?id={id}' => 'Get order details',
        'POST /orders.php' => 'Create order',
        'PUT /orders.php?id={id}&action=deliver' => 'Mark as delivered',
        'POST /orders.php?action=review' => 'Add review',
    ],
    'wallet' => [
        'GET /wallet.php' => 'Get wallet balance and transactions',
        'POST /wallet.php?action=deposit' => 'Create deposit request',
        'POST /wallet.php?action=withdraw' => 'Create withdrawal request',
        'GET /wallet.php?action=deposits' => 'Get deposit history',
        'GET /wallet.php?action=withdraws' => 'Get withdrawal history',
        'GET /wallet.php?action=gateways' => 'Get available gateways',
    ],
    'settings' => [
        'GET /settings.php' => 'Get app settings',
    ],
    'notifications' => [
        'GET /notifications.php' => 'Get notifications',
        'PUT /notifications.php?id={id}' => 'Mark notification as read',
        'PUT /notifications.php?action=read_all' => 'Mark all as read',
    ],
    'reviews' => [
        'GET /reviews.php?seller_id={id}' => 'Get reviews for seller',
    ],
    'social_types' => [
        'GET /social_types.php' => 'Get all active social media types',
    ],
    'upload' => [
        'POST /upload.php?type={type}' => 'Upload file (avatar/screenshot/kyc)',
    ],
    'stats' => [
        'GET /stats.php?type={type}' => 'Get statistics',
    ],
    'search' => [
        'GET /search.php?q={query}&type={type}' => 'Search accounts/sellers',
    ],
    'payment' => [
        'POST /payment_initiate.php' => 'Initiate payment gateway',
        'POST /payment_webhook.php?gateway={gateway}' => 'Payment webhook',
    ],
];

echo json_encode([
    'success' => true,
    'message' => 'Socibuysell API',
    'version' => '1.0.0',
    'base_url' => 'https://sellgmail.piashjodder.my.id/api',
    'endpoints' => $endpoints,
    'authentication' => 'Most endpoints require JWT token in Authorization header: Bearer {token}',
], JSON_PRETTY_PRINT);

