<?php
/**
 * Initiate Payment Gateway
 * Creates payment session for automatic gateways
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$user = requireAuth();
$db = getDB();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $amount = $input['amount'] ?? null;
    $gateway = $input['gateway'] ?? '';
    $depositId = $input['deposit_id'] ?? null;
    
    if (empty($amount) || empty($gateway) || empty($depositId)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Missing required fields']);
        exit;
    }
    
    // UddoktaPay
    if ($gateway === 'uddoktapay') {
        $apiKey = $_ENV['UDDOKTAPAY_API_KEY'] ?? '';
        $apiUrl = $_ENV['UDDOKTAPAY_API_URL'] ?? 'https://sandbox.uddoktapay.com/api/checkout';
        $callbackUrl = BASE_URL . '/api/payment_webhook.php?gateway=uddoktapay';
        $redirectUrl = BASE_URL . '/payment-success';
        
        $data = [
            'full_name' => $user['name'],
            'email' => $user['email'],
            'amount' => $amount,
            'metadata' => [
                'deposit_id' => $depositId,
                'user_id' => $user['id'],
            ],
            'redirect_url' => $redirectUrl,
            'cancel_url' => BASE_URL . '/payment-cancel',
            'webhook_url' => $callbackUrl,
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'RT-UDDOKTAPAY-API-KEY: ' . $apiKey,
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode === 200) {
            $result = json_decode($response, true);
            if (isset($result['payment_url'])) {
                // Update deposit with transaction_id
                $stmt = $db->prepare("UPDATE deposits SET transaction_id = ? WHERE id = ?");
                $stmt->execute([$result['invoice_id'], $depositId]);
                
                echo json_encode([
                    'success' => true,
                    'payment_url' => $result['payment_url'],
                ]);
                exit;
            }
        }
        
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Payment initiation failed']);
        exit;
    }
    
    // SSLCommerz
    if ($gateway === 'sslcommerz') {
        $storeId = $_ENV['SSLCOMMERZ_STORE_ID'] ?? '';
        $storePassword = $_ENV['SSLCOMMERZ_STORE_PASSWORD'] ?? '';
        $tranId = 'DEP' . time() . rand(1000, 9999);
        
        $data = [
            'store_id' => $storeId,
            'store_passwd' => $storePassword,
            'total_amount' => $amount,
            'currency' => 'BDT',
            'tran_id' => $tranId,
            'success_url' => BASE_URL . '/payment-success',
            'fail_url' => BASE_URL . '/payment-fail',
            'cancel_url' => BASE_URL . '/payment-cancel',
            'cus_name' => $user['name'],
            'cus_email' => $user['email'],
            'cus_phone' => '',
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://sandbox.sslcommerz.com/gwprocess/v4/api.php');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        if (strpos($response, 'http') === 0) {
            // Update deposit
            $stmt = $db->prepare("UPDATE deposits SET transaction_id = ? WHERE id = ?");
            $stmt->execute([$tranId, $depositId]);
            
            echo json_encode([
                'success' => true,
                'payment_url' => $response,
            ]);
            exit;
        }
        
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Payment initiation failed']);
        exit;
    }
    
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Unsupported gateway']);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

