<?php
/**
 * Payment Gateway Webhooks
 * Handles callbacks from payment gateways
 */

header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$gateway = $_GET['gateway'] ?? '';

// UddoktaPay Webhook
if ($gateway === 'uddoktapay' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $invoiceId = $input['invoice_id'] ?? '';
    $status = $input['status'] ?? '';
    $amount = $input['amount'] ?? 0;
    
    if ($status === 'COMPLETED' && !empty($invoiceId)) {
        // Find deposit by transaction_id
        $stmt = $db->prepare("SELECT id, user_id, amount FROM deposits WHERE transaction_id = ? AND status = 'pending'");
        $stmt->execute([$invoiceId]);
        $deposit = $stmt->fetch();
        
        if ($deposit && $deposit['amount'] == $amount) {
            // Approve deposit
            $stmt = $db->prepare("UPDATE deposits SET status = 'approved' WHERE id = ?");
            $stmt->execute([$deposit['id']]);
            
            // Update user wallet
            $stmt = $db->prepare("SELECT wallet_balance FROM users WHERE id = ?");
            $stmt->execute([$deposit['user_id']]);
            $user = $stmt->fetch();
            
            $newBalance = $user['wallet_balance'] + $amount;
            $stmt = $db->prepare("UPDATE users SET wallet_balance = ? WHERE id = ?");
            $stmt->execute([$newBalance, $deposit['user_id']]);
            
            // Record transaction
            $stmt = $db->prepare("
                INSERT INTO transactions (user_id, type, amount, balance_before, balance_after, reference_id, description)
                VALUES (?, 'deposit', ?, ?, ?, ?, ?)
            ");
            $stmt->execute([
                $deposit['user_id'],
                $amount,
                $user['wallet_balance'],
                $newBalance,
                $deposit['id'],
                "Deposit via UddoktaPay"
            ]);
            
            // Create notification
            $stmt = $db->prepare("
                INSERT INTO notifications (user_id, title, message, type)
                VALUES (?, 'Deposit Approved', 'Your deposit of ৳? has been approved', 'success')
            ");
            $stmt->execute([$deposit['user_id'], $amount]);
            
            echo json_encode(['success' => true, 'message' => 'Deposit processed']);
            exit;
        }
    }
    
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

// SSLCommerz Webhook
if ($gateway === 'sslcommerz' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $tranId = $_POST['tran_id'] ?? '';
    $status = $_POST['status'] ?? '';
    $amount = $_POST['amount'] ?? 0;
    
    if ($status === 'VALID' && !empty($tranId)) {
        // Verify with SSLCommerz
        $storeId = $_ENV['SSLCOMMERZ_STORE_ID'] ?? '';
        $storePassword = $_ENV['SSLCOMMERZ_STORE_PASSWORD'] ?? '';
        
        $valId = $_POST['val_id'] ?? '';
        $verifyUrl = "https://sandbox.sslcommerz.com/validator/api/validationserverAPI.php?val_id=$valId&store_id=$storeId&store_passwd=$storePassword&format=json";
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $verifyUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $verifyData = json_decode($response, true);
        
        if ($verifyData && $verifyData['status'] === 'VALID') {
            // Process deposit (similar to UddoktaPay)
            $stmt = $db->prepare("SELECT id, user_id, amount FROM deposits WHERE transaction_id = ? AND status = 'pending'");
            $stmt->execute([$tranId]);
            $deposit = $stmt->fetch();
            
            if ($deposit && $deposit['amount'] == $amount) {
                // Approve deposit
                $stmt = $db->prepare("UPDATE deposits SET status = 'approved' WHERE id = ?");
                $stmt->execute([$deposit['id']]);
                
                // Update wallet and create transaction (same as above)
                // ... (similar code to UddoktaPay)
                
                echo json_encode(['success' => true]);
                exit;
            }
        }
    }
    
    echo json_encode(['success' => false]);
    exit;
}

// Stripe Webhook
if ($gateway === 'stripe' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $payload = file_get_contents('php://input');
    $sigHeader = $_SERVER['HTTP_STRIPE_SIGNATURE'] ?? '';
    $endpointSecret = $_ENV['STRIPE_WEBHOOK_SECRET'] ?? '';
    
    try {
        $event = \Stripe\Webhook::constructEvent($payload, $sigHeader, $endpointSecret);
        
        if ($event->type === 'payment_intent.succeeded') {
            $paymentIntent = $event->data->object;
            $metadata = $paymentIntent->metadata;
            
            if (isset($metadata->deposit_id)) {
                // Process deposit
                // ... (similar processing)
            }
        }
    } catch (\Exception $e) {
        http_response_code(400);
        echo json_encode(['error' => $e->getMessage()]);
        exit;
    }
    
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(404);
echo json_encode(['success' => false, 'message' => 'Not found']);

