<?php
/**
 * Rate Limiting
 * Simple rate limiting using file-based storage
 */

function checkRateLimit($identifier, $maxRequests = 100, $timeWindow = 60) {
    $rateLimitDir = __DIR__ . '/../storage/rate_limits';
    if (!file_exists($rateLimitDir)) {
        mkdir($rateLimitDir, 0755, true);
    }
    
    $file = $rateLimitDir . '/' . md5($identifier) . '.json';
    $now = time();
    
    if (file_exists($file)) {
        $data = json_decode(file_get_contents($file), true);
        
        // Reset if time window passed
        if ($now - $data['start_time'] > $timeWindow) {
            $data = ['start_time' => $now, 'count' => 0];
        }
        
        // Check limit
        if ($data['count'] >= $maxRequests) {
            http_response_code(429);
            echo json_encode([
                'success' => false,
                'message' => 'Rate limit exceeded. Please try again later.',
                'retry_after' => $timeWindow - ($now - $data['start_time'])
            ]);
            exit;
        }
        
        $data['count']++;
    } else {
        $data = ['start_time' => $now, 'count' => 1];
    }
    
    file_put_contents($file, json_encode($data));
    return true;
}

// Apply rate limiting to authenticated endpoints
function applyRateLimit($user = null) {
    $identifier = $user ? 'user_' . $user['id'] : 'ip_' . ($_SERVER['REMOTE_ADDR'] ?? 'unknown');
    checkRateLimit($identifier, 100, 60); // 100 requests per minute
}

